<?php

namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\Accessor;

/**
 * CompanyOfferReport
 *
 * @ORM\Table(name="company_offer_reports")
 * @ORM\Entity(repositoryClass="VM\ApiBundle\Repository\CompanyOfferReportRepository")
 *
 * @ExclusionPolicy("all")
 * @ORM\HasLifecycleCallbacks
 */
class CompanyOfferReport
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"bankServiceDetails","companyDetails", "companyBankServiceDetails"})
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="company_id", type="integer")
     */
    private $companyId;

    /**
     * @var integer
     *
     * @ORM\Column(name="round_id", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"companyBankServiceDetails"})
     */
    private $roundId;

    /**
     * @var integer
     *
     * @ORM\Column(name="report_id", type="integer")
     */
    private $reportId;

    /**
     * @ORM\ManyToOne(targetEntity="Company",inversedBy="companyOfferReports")
     * @ORM\JoinColumn(name="company_id", referencedColumnName="id")
     */
    private $company;

    /**
     * @ORM\ManyToOne(targetEntity="Round",inversedBy="roundReports")
     * @ORM\JoinColumn(name="round_id", referencedColumnName="id")
     */
    private $round;

    /**
     * @ORM\ManyToOne(targetEntity="OfferReport",inversedBy="companyOfferReports")
     * @ORM\JoinColumn(name="report_id", referencedColumnName="id")
     *
     * @Expose
     * @AnnotationGroups({})
     */
    private $report;


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set companyId
     *
     * @param integer $companyId
     * @return CompanyOfferReport
     */
    public function setCompanyId($companyId)
    {
        $this->companyId = $companyId;
    
        return $this;
    }

    /**
     * Get companyId
     *
     * @return integer 
     */
    public function getCompanyId()
    {
        return $this->companyId;
    }

    /**
     * Set roundId
     *
     * @param integer $roundId
     * @return CompanyOfferReport
     */
    public function setRoundId($roundId)
    {
        $this->roundId = $roundId;
    
        return $this;
    }

    /**
     * Get roundId
     *
     * @return integer 
     */
    public function getRoundId()
    {
        return $this->roundId;
    }

    /**
     * Set company
     *
     * @param \VM\ApiBundle\Entity\Company $company
     * @return CompanyOfferReport
     */
    public function setCompany(\VM\ApiBundle\Entity\Company $company = null)
    {
        $this->company = $company;
    
        return $this;
    }

    /**
     * Get company
     *
     * @return \VM\ApiBundle\Entity\Company 
     */
    public function getCompany()
    {
        return $this->company;
    }

    /**
     * Set round
     *
     * @param \VM\ApiBundle\Entity\Round $round
     * @return CompanyOfferReport
     */
    public function setRound(\VM\ApiBundle\Entity\Round $round = null)
    {
        $this->round = $round;
    
        return $this;
    }

    /**
     * Get round
     *
     * @return \VM\ApiBundle\Entity\Round 
     */
    public function getRound()
    {
        return $this->round;
    }

    /**
     * Set reportId
     *
     * @param integer $reportId
     * @return CompanyOfferReport
     */
    public function setReportId($reportId)
    {
        $this->reportId = $reportId;
    
        return $this;
    }

    /**
     * Get reportId
     *
     * @return integer 
     */
    public function getReportId()
    {
        return $this->reportId;
    }

    /**
     * Set report
     *
     * @param \VM\ApiBundle\Entity\OfferReport $report
     * @return CompanyOfferReport
     */
    public function setReport(\VM\ApiBundle\Entity\OfferReport $report = null)
    {
        $this->report = $report;
    
        return $this;
    }

    /**
     * Get report
     *
     * @return \VM\ApiBundle\Entity\OfferReport 
     */
    public function getReport()
    {
        return $this->report;
    }
}